targetlist = {
	["blue"] = {
		["Lanchhuti Train Station - FM56"] = {
			task = "Strike",
			priority = 8,
			picture = {"Lanchhuti Train Station.png"},			
			attributes = {"Structure"},
			firepower = {
				min = 2,
				max = 2,
			},
			elements = {
				[1] = {
					name = "Lanchhuti Train Station Hangar 1",
					x = -298182.3125,
					y = 648747.75,
				},
				[2] = {
					name = "Lanchhuti Train Station Hangar 2",
					x = -298317.75854492,
					y = 648772.40039063,
				},
				[3] = {
					name = "Lanchhuti Train Station Hangar 3",
					x = -298273.5,
					y = 648775.5,
				},
				[4] = {
					name = "Lanchhuti Train Station Hangar 4",
					x = -298294.90625,
					y = 648854.125,
				},
			},
		},
		["Tbilisi Train Station - MM81"] = {
			task = "Strike",
			priority = 8,
			picture = {"Tbilisi Train Station.png"},			
			attributes = {"Structure"},
			firepower = {
				min = 2,
				max = 2,
			},
			elements = {
				[1] = {
					name = "Tbilisi Train Station Hangar 1",
					x = -310937.90625,
					y = 882362.9375,
				},
				[2] = {
					name = "Tbilisi Train Station Hangar 2",
					x = -310987.28125,
					y = 882396.8125,
				},
				[3] = {
					name = "Tbilisi Train Station Hangar 3",
					x = -311013.1953125,
					y = 882279.04882813,
				},
				[4] = {
					name = "Tbilisi Train Station Hangar 4",
					x = -310944.76269531,
					y = 882288.11523438,
				},
				[5] = {
					name = "Tbilisi Train Station Hangar 5",
					x = -311094.58105469,
					y = 882374.51953125,
				},
			},
		},
		["Bridge Dapnari-KM76"] = {
			task = "Strike",
			priority = 6,
			picture = {"Bridge Dapnari.png"},
			attributes = {"Bridge"},
			firepower = {
				min = 2,
				max = 2,
			},
			elements = {
				[1] = {
					name = "Bridge Dapnari North part-KM76",
					x = -292658.8359375,
					y = 672266.87695313,
				},
				[2] = {
					name = "Bridge Dapnari South part-KM76",
					x = -292795.8515625,
					y = 672238.12304688,
				},
			},
		},
		["Rail Bridge Ureki-GG35"] = {
			task = "Strike",
			priority = 6,
			picture = {"Rail Bridge Ureki.png"},
			attributes = {"Bridge"},
			firepower = {
				min = 2,
				max = 2,
			},
			elements = {
				[1] = {
					name = "Rail Bridge Ureki South part",
					x = -312308.28125,
					y = 628192.1875,
				},
				[2] = {
					name = "Rail Bridge Ureki North part",
					x = -312242.875,
					y = 628251.5,
				},
			},
		},
		["Bridge Gagma-Dvabzu-KM54"] = {
			task = "Strike",
			priority = 6,
			picture = {"Bridge Gagma-Dvabzu.png"},
			attributes = {"Bridge"},
			firepower = {
				min = 2,
				max = 2,
			},
			elements = {
				[1] = {
					name = "Bridge Gagma-Dvabzu",
					x = -314578.71875,
					y = 651345.8125,
				},
			},
		},
		["Bridge Tbilisi-MM81"] = {
			task = "Strike",
			priority = 6,
			picture = {"Bridge Tbilisi.png"},
			attributes = {"Bridge"},
			firepower = {
				min = 2,
				max = 2,
			},
			elements = {
				[1] = {
					name = "Bridge Tbilisi",
					x = -310618.96875,
					y = 880634.375,
				},
			},
		},
		["Batumi Alert 1"] = {
			task = "Intercept",
			priority = 10,
			attributes = {},
			firepower = {
				min = 1,
				max = 2,
			},
			base = "Batumi",
			radius = 150000,
		},
		["Batumi Alert 2"] = {
			task = "Intercept",
			priority = 10,
			attributes = {},
			firepower = {
				min = 1,
				max = 2,
			},
			base = "Batumi",
			radius = 150000,
		},		
		["Turkish CAP 1"] = {
			task = "CAP",
			priority = 7,
			attributes = {"medium"},
			firepower = {
				min = 2,
				max = 2,
			},
			refpoint = "CAP blue 1",
			radius = 20000,
			text = "south of West troops",
			inactive = false,
		},
		["Turkish CAP 2"] = {
			task = "CAP",
			priority = 7,
			attributes = {"low"},
			firepower = {
				min = 2,
				max = 2,
			},
			refpoint = "CAP blue 2",
			radius = 20000,
			text = "over West troops",
			inactive = true,
		},
		["Turkish CAP 3"] = {
			task = "CAP",
			priority = 7,
			attributes = {"low"},
			firepower = {
				min = 2,
				max = 2,
			},
			refpoint = "CAP blue 3",
			radius = 20000,
			text = "over Esat troops",
			inactive = true,
		},	
		["Airlift Batumi"] = {
			task = "Transport",
			priority = 1,
			attributes = {},
			firepower = {
				min = 1,
				max = 1,
			},
			base = "Incirlik",
			destination = "Batumi",
		},
		["Airlift Incirlik"] = {
			task = "Transport",
			priority = 1,
			attributes = {},
			firepower = {
				min = 1,
				max = 1,
			},
			base = "Batumi",
			destination = "Incirlik",
		},		
		["Senaki-Kolkhi OCA Strike"] = {
			task = "Strike",
			priority = 4,
			attributes = {"Parked Aircraft"},
			firepower = {
				min = 2,
				max = 2,
			},
			class = "airbase",
			name = "Senaki-Kolkhi",
		},
		["Vaziani OCA Strike"] = {
			task = "Strike",
			priority = 4,
			attributes = {"Parked Aircraft"},
			firepower = {
				min = 2,
				max = 2,
			},
			class = "airbase",
			name = "Vaziani",
		},
		["Kutaisi OCA Strike"] = {
			task = "Strike",
			priority = 4,
			attributes = {"Parked Aircraft"},
			firepower = {
				min = 2,
				max = 2,
			},
			class = "airbase",
			name = "Kutaisi",
		},
		["GA-EWR1"] = {
			task = "Strike",
			priority = 10,
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 2,
			},
			class = "vehicle",
			name = "GA-EWR1",
		},
		["GA-EWR2"] = {
			task = "Strike",
			priority = 10,
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 2,
			},
			class = "vehicle",
			name = "GA-EWR2",
		},
		["GA-EWR3"] = {
			task = "Strike",
			priority = 10,
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 2,
			},
			class = "vehicle",
			name = "GA-EWR3",
		},
		-- ["Georgia Air Defense SA-3 Vaziani"] = {
			-- task = "Strike",
			-- priority = 6,
			-- attributes = {"SAM"},
			-- firepower = {
				-- min = 2,
				-- max = 4,
			-- },
			-- class = "vehicle",
			-- name = "Georgia Air Defense SA-3 Vaziani",
		-- },
		-- ["Georgia Air Defense SA-3 Kutaisi"] = {
			-- task = "Strike",
			-- priority = 6,
			-- attributes = {"SAM"},
			-- firepower = {
				-- min = 2,
				-- max = 4,
			-- },
			-- class = "vehicle",
			-- name = "Georgia Air Defense SA-3 Kutaisi",
		-- },
		-- ["Georgia Air Defense SA-3 Senaki"] = {
			-- task = "Strike",
			-- priority = 6,
			-- attributes = {"SAM"},
			-- firepower = {
				-- min = 2,
				-- max = 4,
			-- },
			-- class = "vehicle",
			-- name = "Georgia Air Defense SA-3 Senaki",
		-- },
		["Senaki Airbase"] = {
			task = "Strike",
			priority = 8,
			picture = {"Senaki Airbase.png", "Senaki Airbase-Ammo.png"},			
			attributes = {"Structure"},
			firepower = {
				min = 2,
				max = 2,
			},
			elements = {
				[1] = {
					name = "Senaki Control Tower",
					x = -280806.5625,
					y = 646965.25,
				},
				[2] = {
					name = "Senaki Main Ammo Depot",
					x = -282847.90625,
					y = 646751.875,
				},
				[3] = {
					name = "Senaki Ammo Depot 1",
					x = -282812.40625,
					y = 646740.4375,
				},
				[4] = {
					name = "Senaki Ammo Depot 2",
					x = -282816,
					y = 646749.3125,
				},
				[5] = {
					name = "Senaki Ammo Depot 3",
					x = -282823.125,
					y = 646766.8125,
				},
				[6] = {
					name = "Senaki Ammo Depot 4",
					x = -282819.53125,
					y = 646757.9375,
				},				
				[7] = {
					name = "Senaki Ammo Depot 5",
					x = -282872.53125,
					y = 646713.3125,
				},
				[8] = {
					name = "Senaki Ammo Depot 6",
					x = -282879.65625,
					y = 646730.75,
				},
				[9] = {
					name = "Senaki Ammo Depot 7",
					x = -282876.125,
					y = 646722.125,
				},
				[10] = {
					name = "Senaki Ammo Depot 8",
					x = -282883.21875,
					y = 646739.625,
				},
				[11] = {
					name = "Senaki Ammo Depot 9",
					x = -282792.4375,
					y = 646691.5,
				},
				[12] = {
					name = "Senaki Ammo Depot 10",
					x = -282788.8125,
					y = 646682.625,
				},
				[13] = {
					name = "Senaki Ammo Depot 11",
					x = -282850.9375,
					y = 646660.0625,
				},
				[14] = {
					name = "Senaki Ammo Depot 12",
					x = -282854.53125,
					y = 646668.9375,
				},
				[15] = {
					name = "Senaki Ammo Depot 13",
					x = -282847.4375,
					y = 646651.4375,
				},
				[16] = {
					name = "Senaki Ammo Depot 14",
					x = -282825.5,
					y = 646597.4375,
				},
				[17] = {
					name = "Senaki Ammo Depot 15",
					x = -282829.09375,
					y = 646606.3125,
				},
				[18] = {
					name = "Senaki Ammo Depot 16",
					x = -282832.59375,
					y = 646614.9375,
				},
				[19] = {
					name = "Senaki Ammo Depot 17",
					x = -282836.21875,
					y = 646623.8125,
				},
				[20] = {
					name = "Senaki Ammo Depot 18",
					x = -282799.3125,
					y = 646614.375,
				},
				[21] = {
					name = "Senaki Fuel Depot 1",
					x = -280223.46875,
					y = 646882.5625,
				},
				[22] = {
					name = "Senaki Fuel Depot 2",
					x = -280257.1875,
					y = 646685.1875,
				},
				[23] = {
					name = "Senaki Fuel Depot 3",
					x = -280330.03125,
					y = 646706.8125,
				},
				[24] = {
					name = "Senaki Fuel Depot 4",
					x = -280305.5,
					y = 646808.625,
				},
				[25] = {
					name = "Senaki Power Supply",
					x = -281924.46875,
					y = 645939.3125,
				},
				[26] = {
					name = "Senaki Hangar 1",
					x = -280708.84375,
					y = 647660.1875,
				},
				[27] = {
					name = "Senaki Hangar 2",
					x = -280663,
					y = 647573.875,
				},
				[28] = {
					name = "Senaki Hangar 3",
					x = -280709.46875,
					y = 647200.5,
				},
				[29] = {
					name = "Senaki Hangar 4",
					x = -280812.5625,
					y = 647103.625,
				},
				[30] = {
					name = "Senaki Hangar 5",
					x = -280773.84375,
					y = 647140.5625,
				},
				[31] = {
					name = "Senaki Hangar 6",
					x = -281007.71875,
					y = 647236,
				},
				[32] = {
					name = "Senaki Hangar 7",
					x = -281047.84375,
					y = 647268.0625,
				},
				[33] = {
					name = "Senaki Hangar 8",
					x = -281449.625,
					y = 646244.5,
				},
				[34] = {
					name = "Senaki Command Center 1",
					x = -280573.5625,
					y = 647218.25,
				},
				[35] = {
					name = "Senaki Command Center 2",
					x = -280655.46875,
					y = 647088.125,
				},
				[36] = {
					name = "Senaki Communication Center",
					x = -281379.90625,
					y = 646323.0625,
				},
			},
		},
		["Kutaisi Airbase"] = {
			task = "Strike",
			priority = 8,
			picture = {"Kutaisi Airbase.png", "Kutaisi Airbase-AmmoFuel.png"},			
			attributes = {"Structure"},
			firepower = {
				min = 2,
				max = 2,
			},
			elements = {
				[1] = {
					name = "Kutaisi Control Tower",
					x = -284566.3125,
					y = 683780.0625,
				},
				[2] = {
					name = "Kutaisi Main Ammo Depot",
					x = -285856.6875,
					y = 683802.875,
				},
				[3] = {
					name = "Kutaisi Ammo Depot 1",
					x = -285843.96875,
					y = 683828.9375,
				},
				[4] = {
					name = "Kutaisi Ammo Depot 2",
					x = -285853.15625,
					y = 683831.5625,
				},
				[5] = {
					name = "Kutaisi Ammo Depot 3",
					x = -285835,
					y = 683826.4375,
				},
				[6] = {
					name = "Kutaisi Ammo Depot 4",
					x = -285825.78125,
					y = 683823.75,
				},				
				[7] = {
					name = "Kutaisi Ammo Depot 5",
					x = -285868.875,
					y = 683767.5625,
				},
				[8] = {
					name = "Kutaisi Ammo Depot 6",
					x = -285850.71875,
					y = 683762.375,
				},
				[9] = {
					name = "Kutaisi Ammo Depot 7",
					x = -285859.6875,
					y = 683764.875,
				},
				[10] = {
					name = "Kutaisi Ammo Depot 8",
					x = -285841.53125,
					y = 683759.6875,
				},
				[11] = {
					name = "Kutaisi Ammo Depot 9",
					x = -285765.75,
					y = 683806.6875,
				},
				[12] = {
					name = "Kutaisi Ammo Depot 10",
					x = -285774.96875,
					y = 683809.3125,
				},
				[13] = {
					name = "Kutaisi Ammo Depot 11",
					x = -285777.375,
					y = 683741.3125,
				},
				[14] = {
					name = "Kutaisi Ammo Depot 12",
					x = -285795.53125,
					y = 683746.5,
				},
				[15] = {
					name = "Kutaisi Ammo Depot 13",
					x = -285786.34375,
					y = 683743.875,
				},
				[16] = {
					name = "Kutaisi Ammo Depot 14",
					x = -285748.71875,
					y = 683733.0625,
				},
				[17] = {
					name = "Kutaisi Ammo Depot 15",
					x = -285739.5,
					y = 683730.5,
				},
				[18] = {
					name = "Kutaisi Ammo Depot 16",
					x = -285730.5625,
					y = 683727.875,
				},
				[19] = {
					name = "Kutaisi Ammo Depot 17",
					x = -285721.34375,
					y = 683725.25,
				},
				[20] = {
					name = "Kutaisi Ammo Depot 18",
					x = -285718.5,
					y = 683756.3125,
				},
				[21] = {
					name = "Kutaisi Fuel Depot 1",
					x = -285673.59375,
					y = 685097.1875,
				},
				[22] = {
					name = "Kutaisi Fuel Depot 2",
					x = -285763.34375,
					y = 685069.125,
				},
				[23] = {
					name = "Kutaisi Fuel Depot 3",
					x = -285847.0625,
					y = 685006.125,
				},
				[24] = {
					name = "Kutaisi Communication Center",
					x = -284333.28125,
					y = 683327.3125,
				},
				[25] = {
					name = "Kutaisi Power Supply",
					x = -284195.59375,
					y = 682949.75,
				},
				[26] = {
					name = "Kutaisi Hangar 1",
					x = -284214,
					y = 682983.375,
				},
				[27] = {
					name = "Kutaisi Hangar 2",
					x = -284263.5,
					y = 683027.0625,
				},
				[28] = {
					name = "Kutaisi Hangar 3",
					x = -284305.5,
					y = 682967.5,
				},
				[29] = {
					name = "Kutaisi Hangar 4",
					x = -284238.75,
					y = 683005.25,
				},
				[30] = {
					name = "Kutaisi Hangar 5",
					x = -284331.5,
					y = 683082.5,
				},
				[31] = {
					name = "Kutaisi Hangar 6",
					x = -284269.59375,
					y = 683079.8125,
				},
				[32] = {
					name = "Kutaisi Hangar 7",
					x = -284501.1875,
					y = 682949.125,
				},
				[33] = {
					name = "Kutaisi Command Center 1",
					x = -284312.34375,
					y = 682837.625,
				},
				[34] = {
					name = "Kutaisi Command Center 2",
					x = -284396.40625,
					y = 682946.3125,
				},
			},
		},
		["Vaziani Airbase"] = {
			task = "Strike",
			priority = 6,
			picture = {"Vaziani Airbase.png", "Vaziani Airbase-Depots.png"},			
			attributes = {"Structure"},
			firepower = {
				min = 2,
				max = 2,
			},
			elements = {
				[1] = {
					name = "Vaziani Control Tower",
					x = -319586.40625,
					y = 904275.4375,
				},
				[2] = {
					name = "Vaziani Main Ammo Depot",
					x = -318325.375,
					y = 903489.9375,
				},
				[3] = {
					name = "Vaziani Ammo Depot 1",
					x = -318279.96875,
					y = 903484.25,
				},
				[4] = {
					name = "Vaziani Ammo Depot 2",
					x = -318299.25,
					y = 903463.25,
				},
				[5] = {
					name = "Vaziani Ammo Depot 3",
					x = -318292.75,
					y = 903470.3125,
				},
				[6] = {
					name = "Vaziani Ammo Depot 4",
					x = -318286.46875,
					y = 903477.125,
				},				
				[7] = {
					name = "Vaziani Ammo Depot 5",
					x = -318330.15625,
					y = 903526.875,
				},
				[8] = {
					name = "Vaziani Ammo Depot 6",
					x = -318336.6875,
					y = 903519.875,
				},
				[9] = {
					name = "Vaziani Ammo Depot 7",
					x = -318349.46875,
					y = 903505.9375,
				},
				[10] = {
					name = "Vaziani Ammo Depot 8",
					x = -318342.9375,
					y = 903513.0625,
				},
				[11] = {
					name = "Vaziani Ammo Depot 9",
					x = -318247.59375,
					y = 903519.4375,
				},
				[12] = {
					name = "Vaziani Ammo Depot 10",
					x = -318241.15625,
					y = 903526.5,
				},
				[13] = {
					name = "Vaziani Ammo Depot 11",
					x = -318234.8125,
					y = 903533.3125,
				},
				[14] = {
					name = "Vaziani Ammo Depot 12",
					x = -318294.5625,
					y = 903565.9375,
				},
				[15] = {
					name = "Vaziani Ammo Depot 13",
					x = -318288.09375,
					y = 903572.9375,
				},
				[16] = {
					name = "Vaziani Ammo Depot 14",
					x = -318208.15625,
					y = 903562.375,
				},
				[17] = {
					name = "Vaziani Ammo Depot 15",
					x = -318195.40625,
					y = 903576.25,
				},
				[18] = {
					name = "Vaziani Ammo Depot 16",
					x = -318214.6875,
					y = 903555.3125,
				},
				[19] = {
					name = "Vaziani Ammo Depot 17",
					x = -318201.84375,
					y = 903569.25,
				},
				[20] = {
					name = "Vaziani Ammo Depot 18",
					x = -318221.84375,
					y = 903592.6875,
				},
				[21] = {
					name = "Vaziani Fuel Depot 1",
					x = -318529.40625,
					y = 903601.75,
				},
				[22] = {
					name = "Vaziani Fuel Depot 2",
					x = -318389.96875,
					y = 903766.875,
				},
				[23] = {
					name = "Vaziani Fuel Depot 3",
					x = -318587.5,
					y = 903654,
				},
				[24] = {
					name = "Vaziani Fuel Depot 4",
					x = -318518.53125,
					y = 903732.9375,
				},
				[25] = {
					name = "Vaziani Communication Center",
					x = -319699.53125,
					y = 904174.8125,
				},
				[26] = {
					name = "Vaziani Power Supply",
					x = -319028.3125,
					y = 903716.625,
				},
				[27] = {
					name = "Vaziani Hangar 1",
					x = -319677.625,
					y = 904340.5625,
				},
				[28] = {
					name = "Vaziani Hangar 2",
					x = -319657.625,
					y = 904143.8125,
				},
				[29] = {
					name = "Vaziani Hangar 3",
					x = -319537.84375,
					y = 904225.3125,
				},
				[30] = {
					name = "Vaziani Hangar 4",
					x = -319468.59375,
					y = 904233.875,
				},
				[31] = {
					name = "Vaziani Hangar 5",
					x = -318908.84375,
					y = 904055.9375,
				},
				[32] = {
					name = "Vaziani Hangar 6",
					x = -317692.9375,
					y = 902700.5625,
				},
				[33] = {
					name = "Vaziani Hangar 7",
					x = -319431.90625,
					y = 904152.6875,
				},
				[34] = {
					name = "Vaziani Command Center 1",
					x = -319302.125,
					y = 904029.5,
				},
				[35] = {
					name = "Vaziani Command Center 2",
					x = -318880.90625,
					y = 904134.75,
				},
			},
		},
		["1st ArmorBrigade GeorgianArmy"] = {
			task = "Strike",
			priority = 6,
			picture = {},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 2,
			},
			class = "static",
			elements = {
				[1] = {
					name = "1st AB - GA - 1-1",
				},
				[2] = {
					name = "1st AB - GA - 1-2",
				},
				[3] = {
					name = "1st AB - GA - 1-3",
				},
				[4] = {
					name = "1st AB - GA - 1-4",
				},
				[5] = {
					name = "1st AB - GA - 1-5",
				},
				[6] = {
					name = "1st AB - GA - 1-6",
				},
				[7] = {
					name = "1st AB - GA - 1-7",
				},
				[8] = {
					name = "1st AB - GA - 1-8",
				},
				[9] = {
					name = "1st AB - GA - 1-9",
				},
				[10] = {
					name = "1st AB - GA - 1-10",
				},	
				[11] = {
					name = "1st AB - GA - 1-11",
				},	
			},	
		},
		["2nd ArmorBrigade GeorgianArmy"] = {
			task = "Strike",
			priority = 6,
			picture = {},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 2,
			},
			class = "static",
			elements = {
				[1] = {
					name = "2nd AB - GA - 1-1",
				},
				[2] = {
					name = "2nd AB - GA - 1-2",
				},
				[3] = {
					name = "2nd AB - GA - 1-3",
				},
				[4] = {
					name = "2nd AB - GA - 1-4",
				},
				[5] = {
					name = "2nd AB - GA - 1-5",
				},
				[6] = {
					name = "2nd AB - GA - 1-6",
				},
				[7] = {
					name = "2nd AB - GA - 1-7",
				},
				[8] = {
					name = "2nd AB - GA - 1-8",
				},
				[9] = {
					name = "2nd AB - GA - 1-9",
				},
				[10] = {
					name = "2nd AB - GA - 1-10",
				},	
				[11] = {
					name = "2nd AB - GA - 1-11",
				},	
			},	
		},
		["3rd ArmorBrigade GeorgianArmy"] = {
			task = "Strike",
			priority = 6,
			picture = {},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 2,
			},
			class = "static",
			elements = {
				[1] = {
					name = "3rd AB - GA - 1-1",
				},
				[2] = {
					name = "3rd AB - GA - 1-2",
				},
				[3] = {
					name = "3rd AB - GA - 1-3",
				},
				[4] = {
					name = "3rd AB - GA - 1-4",
				},
				[5] = {
					name = "3rd AB - GA - 1-5",
				},
				[6] = {
					name = "3rd AB - GA - 1-6",
				},
				[7] = {
					name = "3rd AB - GA - 1-7",
				},
				[8] = {
					name = "3rd AB - GA - 1-8",
				},
				[9] = {
					name = "3rd AB - GA - 1-9",
				},
				[10] = {
					name = "3rd AB - GA - 1-10",
				},	
				[11] = {
					name = "3rd AB - GA - 1-11",
				},	
			},	
		},
		["4th ArmorBrigade GeorgianArmy"] = {
			task = "Strike",
			priority = 6,
			picture = {},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 2,
			},
			class = "static",
			elements = {
				[1] = {
					name = "4th AB - GA - 1-1",
				},
				[2] = {
					name = "4th AB - GA - 1-2",
				},
				[3] = {
					name = "4th AB - GA - 1-3",
				},
				[4] = {
					name = "4th AB - GA - 1-4",
				},
				[5] = {
					name = "4th AB - GA - 1-5",
				},
				[6] = {
					name = "4th AB - GA - 1-6",
				},
				[7] = {
					name = "4th AB - GA - 1-7",
				},
				[8] = {
					name = "4th AB - GA - 1-8",
				},
				[9] = {
					name = "4th AB - GA - 1-9",
				},
				[10] = {
					name = "4th AB - GA - 1-10",
				},	
				[11] = {
					name = "4th AB - GA - 1-11",
				},
			},	
		},
		["5th ArmorBrigade GeorgianArmy"] = {
			task = "Strike",
			priority = 6,
			picture = {},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 2,
			},
			class = "static",
			elements = {
				[1] = {
					name = "5th AB - GA - 1-1",
				},
				[2] = {
					name = "5th AB - GA - 1-2",
				},
				[3] = {
					name = "5th AB - GA - 1-3",
				},
				[4] = {
					name = "5th AB - GA - 1-4",
				},
				[5] = {
					name = "5th AB - GA - 1-5",
				},
				[6] = {
					name = "5th AB - GA - 1-6",
				},
				[7] = {
					name = "5th AB - GA - 1-7",
				},
				[8] = {
					name = "5th AB - GA - 1-8",
				},
				[9] = {
					name = "5th AB - GA - 1-9",
				},
				[10] = {
					name = "5th AB - GA - 1-10",
				},	
				[11] = {
					name = "5th AB - GA - 1-11",
				},	
			},	
		},
		["1st MechanizedBrigade GeorgianArmy"] = {
			task = "Strike",
			priority = 6,
			picture = {},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 2,
			},
			class = "static",
			elements = {
				[1] = {
					name = "1st MB - GA - 1-1",
				},
				[2] = {
					name = "1st MB - GA - 1-2",
				},
				[3] = {
					name = "1st MB - GA - 1-3",
				},
				[4] = {
					name = "1st MB - GA - 1-4",
				},
				[5] = {
					name = "1st MB - GA - 1-5",
				},
				[6] = {
					name = "1st MB - GA - 1-6",
				},
				[7] = {
					name = "1st MB - GA - 1-7",
				},
				[8] = {
					name = "1st MB - GA - 1-8",
				},
				[9] = {
					name = "1st MB - GA - 1-9",
				},
				[10] = {
					name = "1st MB - GA - 1-10",
				},	
				[11] = {
					name = "1st MB - GA - 1-11",
				},	
			},	
		},
		["2nd MechanizedBrigade GeorgianArmy"] = {
			task = "Strike",
			priority = 6,
			picture = {},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 2,
			},
			class = "static",
			elements = {
				[1] = {
					name = "2nd MB - GA - 1-1",
				},
				[2] = {
					name = "2nd MB - GA - 1-2",
				},
				[3] = {
					name = "2nd MB - GA - 1-3",
				},
				[4] = {
					name = "2nd MB - GA - 1-4",
				},
				[5] = {
					name = "2nd MB - GA - 1-5",
				},
				[6] = {
					name = "2nd MB - GA - 1-6",
				},
				[7] = {
					name = "2nd MB - GA - 1-7",
				},
				[8] = {
					name = "2nd MB - GA - 1-8",
				},
				[9] = {
					name = "2nd MB - GA - 1-9",
				},
				[10] = {
					name = "2nd MB - GA - 1-10",
				},	
				[11] = {
					name = "2nd MB - GA - 1-11",
				},	
			},	
		},
		["3rd MechanizedBrigade GeorgianArmy"] = {
			task = "Strike",
			priority = 6,
			picture = {},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 2,
			},
			class = "static",
			elements = {
				[1] = {
					name = "3rd MB - GA - 1-1",
				},
				[2] = {
					name = "3rd MB - GA - 1-2",
				},
				[3] = {
					name = "3rd MB - GA - 1-3",
				},
				[4] = {
					name = "3rd MB - GA - 1-4",
				},
				[5] = {
					name = "3rd MB - GA - 1-5",
				},
				[6] = {
					name = "3rd MB - GA - 1-6",
				},
				[7] = {
					name = "3rd MB - GA - 1-7",
				},
				[8] = {
					name = "3rd MB - GA - 1-8",
				},
				[9] = {
					name = "3rd MB - GA - 1-9",
				},
				[10] = {
					name = "3rd MB - GA - 1-10",
				},	
				[11] = {
					name = "3rd MB - GA - 1-11",
				},	
			},	
		},
		["4th MechanizedBrigade GeorgianArmy"] = {
			task = "Strike",
			priority = 6,
			picture = {},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 2,
			},
			class = "static",
			elements = {
				[1] = {
					name = "4th MB - GA - 1-1",
				},
				[2] = {
					name = "4th MB - GA - 1-2",
				},
				[3] = {
					name = "4th MB - GA - 1-3",
				},
				[4] = {
					name = "4th MB - GA - 1-4",
				},
				[5] = {
					name = "4th MB - GA - 1-5",
				},
				[6] = {
					name = "4th MB - GA - 1-6",
				},
				[7] = {
					name = "4th MB - GA - 1-7",
				},
				[8] = {
					name = "4th MB - GA - 1-8",
				},
				[9] = {
					name = "4th MB - GA - 1-9",
				},
				[10] = {
					name = "4th MB - GA - 1-10",
				},	
				[11] = {
					name = "4th MB - GA - 1-11",
				},	
			},	
		},
		["1st ArtySupportDivision GeorgianArmy"] = {
			task = "Strike",
			priority = 3,
			picture = {},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 2,
			},
			class = "static",
			elements = {
				[1] = {
					name = "1st ASD-GA-Div1-1",
				},
				[2] = {
					name = "1st ASD-GA-Div1-2",
				},
				[3] = {
					name = "1st ASD-GA-Div1-3",
				},
				[4] = {
					name = "1st ASD-GA-Div1-4",
				},
				[5] = {
					name = "1st ASD-GA-Div1-5",
				},
				[6] = {
					name = "1st ASD-GA-Div1-6",
				},
				[7] = {
					name = "1st ASD-GA-Div1-7",
				},
				[8] = {
					name = "1st ASD-GA-Div1-8",
				},
				[9] = {
					name = "1st ASD-GA-Div1-9",
				},
				[10] = {
					name = "1st ASD-GA-Div1-10",
				},	
			},	
		},
		["2nd ArtySupportDivision GeorgianArmy"] = {
			task = "Strike",
			priority = 3,
			picture = {},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 2,
			},
			class = "static",
			elements = {
				[1] = {
					name = "2nd ASD-GA-Div1-1",
				},
				[2] = {
					name = "2nd ASD-GA-Div1-2",
				},
				[3] = {
					name = "2nd ASD-GA-Div1-3",
				},
				[4] = {
					name = "2nd ASD-GA-Div1-4",
				},
				[5] = {
					name = "2nd ASD-GA-Div1-5",
				},
				[6] = {
					name = "2nd ASD-GA-Div1-6",
				},
				[7] = {
					name = "2nd ASD-GA-Div1-7",
				},
				[8] = {
					name = "2nd ASD-GA-Div1-8",
				},
				[9] = {
					name = "2nd ASD-GA-Div1-9",
				},
				[10] = {
					name = "2nd ASD-GA-Div1-10",
				},	
			},	
		},
		["Georgian Army Supply Convoys 1"] = {
			task = "Strike",
			priority = 3,
			picture = {},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 2,
			},
			class = "vehicle",
			name = "GA-SC1",
		},
		["Georgian Army Supply Convoys 2"] = {
			task = "Strike",
			priority = 3,
			picture = {},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 2,
			},
			class = "vehicle",
			name = "GA-SC2",
		},
		["Georgian Army Supply Convoys 3"] = {
			task = "Strike",
			priority = 3,
			picture = {},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 2,
			},
			class = "vehicle",
			name = "GA-SC3",
		},
		["Georgian Army Supply Convoys 4"] = {
			task = "Strike",
			priority = 3,
			picture = {},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 2,
			},
			class = "vehicle",
			name = "GA-SC4",
		},
		["Georgian Army Supply Convoys 5"] = {
			task = "Strike",
			priority = 3,
			picture = {},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 2,
			},
			class = "vehicle",
			name = "GA-SC5",
		},
		["Airlift UH-1 Batumi"] = {
			task = "Transport",
			priority = 1,
			attributes = {},
			firepower = {
				min = 1,
				max = 1,
			},
			base = "FARP-1st THR",
			destination = "Batumi",
		},
		["Airlift Diyarbakir"] = {
			task = "Transport",
			priority = 1,
			attributes = {},
			firepower = {
				min = 1,
				max = 1,
			},
			base = "Batumi",
			destination = "Diyarbakir",
		},
		["Airlift Batumi"] = {
			task = "Transport",
			priority = 1,
			attributes = {},
			firepower = {
				min = 1,
				max = 1,
			},
			base = "Diyarbakir",
			destination = "Batumi",
		},
	},
	["red"] = {
		["Batumi Airbase"] = {
			task = "Strike",
			priority = 6,
			picture = {"Batumi Airbase.png", "Batumi Airbase-Ammo.png"},			
			attributes = {"Structure"},
			firepower = {
				min = 2,
				max = 4,
			},
			elements = {
				[1] = {
					name = "Batumi Control Tower",
					x = -355688.28125,
					y = 617693,
				},
				[2] = {
					name = "Batumi Main Ammo Depot",
					x = -355414.625,
					y = 617513.1875,
				},
				[3] = {
					name = "Batumi Ammo Depot 1",
					x = -355494.59375,
					y = 617445.625,
				},
				[4] = {
					name = "Batumi Ammo Depot 2",
					x = -355438.48291016,
					y = 617354.99682617,
				},
				[5] = {
					name = "Batumi Ammo Depot 3",
					x = -355382.0625,
					y = 617296.9375,
				},
				[6] = {
					name = "Batumi Fuel Depot 1",
					x = -355929.40625,
					y = 618273.875,
				},
				[7] = {
					name = "Batumi Fuel Depot 2",
					x = -355926.875,
					y = 618297.6875,
				},
				[8] = {
					name = "Batumi Power Supply",
					x = -355586.30224609,
					y = 617921.95751953,
				},
				[9] = {
					name = "Batumi Hangar 1",
					x = -356082.15625,
					y = 618377,
				},
				[10] = {
					name = "Batumi Hangar 2",
					x = -356147.5,
					y = 618389.25,
				},
				[11] = {
					name = "Batumi Hangar 3",
					x = -356193.8125,
					y = 618383.6875,
				},
				[12] = {
					name = "Batumi Hangar 4",
					x = -356258.34375,
					y = 618359.375,
				},
				[13] = {
					name = "Batumi Hangar 5",
					x = -355467.21875,
					y = 617597.6875,
				},
				[14] = {
					name = "Batumi Hangar 6",
					x = -355432.3125,
					y = 617586.625,
				},
				[15] = {
					name = "Batumi Hangar 7",
					x = -355603.28125,
					y = 617639.3125,
				},				
				[16] = {
					name = "Batumi Command Center 1",
					x = -355499.375,
					y = 617559.6875,
				},
				[17] = {
					name = "Batumi Command Center 2",
					x = -355546.5,
					y = 617541.6875,
				},
			},
		},
		["Batumi Airbase Strategics"] = {
			task = "Strike",
			priority = 6,
			picture = {"Batumi Airbase.png", "Batumi Airbase-Ammo.png"},
			attributes = {"Structure"},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Batumi Fuel Tank 1",
				},
				[2] = {
					name = "Batumi Fuel Tank 2",
				},
				[3] = {
					name = "Batumi Fuel Tank 3",
				},
				[4] = {
					name = "Batumi Fuel Tank 4",
				},
				[5] = {
					name = "Batumi Fuel Tank 5",
				},
				[6] = {
					name = "Batumi Fuel Tank 6",
				},
				[7] = {
					name = "Batumi Ammo Dump 1",
				},
				[8] = {
					name = "Batumi Ammo Dump 2",
				},
				[9] = {
					name = "Batumi Ammo Dump 3",
				},
				[10] = {
					name = "Batumi Ammo Dump 4",
				},				
				[11] = {
					name = "Batumi Command Center",
				},
				[12] = {
					name = "Batumi Power Supply",
				},				
			},
		},
		["Shakva Train Station - GG22"] = {
			task = "Strike",
			priority = 6,
			picture = {"Shakva Train Station.png"},			
			attributes = {"Structure"},
			firepower = {
				min = 2,
				max = 2,
			},
			elements = {
				[1] = {
					name = "Shakva Train Station Hangar 1",
					x = -340690.81689453,
					y = 626987.1796875,
				},
				[2] = {
					name = "Shakva Train Station Hangar 2",
					x = -340701.5,
					y = 627058.0625,
				},
				[3] = {
					name = "Shakva Train Station Hangar 3",
					x = -340747.4375,
					y = 627049.6875,
				},
			},
		},
		["Bridge Kobuleti South-GG33"] = {
			task = "Strike",
			priority = 6,
			picture = {"Bridges Kobuleti.png"},
			attributes = {"Bridge"},
			firepower = {
				min = 2,
				max = 2,
			},
			elements = {
				[1] = {
					name = "Bridge Kobuleti South",
					x = -333117.59375,
					y = 629579.1171875,
				},
			},
		},
		["Bridge Kobuleti South East-GG33"] = {
			task = "Strike",
			priority = 6,
			picture = {"Bridges Kobuleti.png"},
			attributes = {"Bridge"},
			firepower = {
				min = 2,
				max = 2,
			},
			elements = {
				[1] = {
					name = "Bridge Kobuleti South East",
					x = -334687.5,
					y = 630929.375,
				},
			},
		},
		["Bridge Kolagiri-ML79"] = {
			task = "Strike",
			priority = 5,
			picture = {"Bridge Kolagiri.png"},
			attributes = {"Bridge"},
			firepower = {
				min = 2,
				max = 2,
			},
			elements = {
				[1] = {
					name = "Bridge Kolagiri",
					x = -339866.78125,
					y = 878292.5,
				},
			},
		},
		["Bridge NL08"] = {
			task = "Strike",
			priority = 5,
			picture = {"Bridge NL08.png"},
			attributes = {"Bridge"},
			firepower = {
				min = 2,
				max = 2,
			},
			elements = {
				[1] = {
					name = "Bridge NL08",
					x = -345101.0625,
					y = 907505.125,
				},
			},
		},
		["Senaki-Kolkhi Alert 1"] = {
			task = "Intercept",
			priority = 10,
			attributes = {},
			firepower = {
				min = 1,
				max = 2,
			},
			base = "Senaki-Kolkhi",
			radius = 150000,
			inactive = false,
		},
		["Senaki-Kolkhi Alert 2"] = {
			task = "Intercept",
			priority = 10,
			attributes = {},
			firepower = {
				min = 1,
				max = 2,
			},
			base = "Senaki-Kolkhi",
			radius = 100000,
			inactive = false,
		},
		["Georgian CAP 1"] = {
			task = "CAP",
			priority = 4,
			attributes = {"medium"},
			firepower = {
				min = 2,
				max = 2,
			},
			refpoint = "CAP red 1",
			radius = 24000,
			text = "North of our troops",
			inactive = false,
		},
		["Georgian CAP 2"] = {
			task = "CAP",
			priority = 7,
			attributes = {"low"},
			firepower = {
				min = 2,
				max = 2,
			},
			refpoint = "CAP red 2",
			radius = 20000,
			text = "Over our West troops",
			inactive = true,
		},
		["Georgian CAP 3"] = {
			task = "CAP",
			priority = 7,
			attributes = {"low"},
			firepower = {
				min = 2,
				max = 2,
			},
			refpoint = "CAP red 3",
			radius = 20000,
			text = "Over our East troops",
			inactive = true,
		},
		["TEF-EWR"] = {
			task = "Strike",
			priority = 10,
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 2,
			},
			class = "vehicle",
			name = "TEF-EWR",
		},	
		["Batumi OCA Strike"] = {
			task = "Strike",
			priority = 4,
			attributes = {"Parked Aircraft"},
			firepower = {
				min = 2,
				max = 2,
			},
			class = "airbase",
			name = "Batumi",
		},
		["1st ArmorBrigade TurkishExpeditionaryForces"] = {
			task = "Strike",
			priority = 7,
			picture = {},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 2,
			},
			class = "static",
			elements = {
				[1] = {
					name = "1st AB - TEF Div - 1-1",
				},
				[2] = {
					name = "1st AB - TEF Div - 1-2",
				},
				[3] = {
					name = "1st AB - TEF Div - 1-3",
				},
				[4] = {
					name = "1st AB - TEF Div - 1-4",
				},
				[5] = {
					name = "1st AB - TEF Div - 1-5",
				},
				[6] = {
					name = "1st AB - TEF Div - 1-6",
				},
				[7] = {
					name = "1st AB - TEF Div - 1-7",
				},
				[8] = {
					name = "1st AB - TEF Div - 1-8",
				},
				[9] = {
					name = "1st AB - TEF Div - 1-9",
				},
				[10] = {
					name = "1st AB - TEF Div - 1-10",
				},	
				[11] = {
					name = "1st AB - TEF Div - 1-11",
				},
				[12] = {
					name = "1st AB - TEF Div - 1-12",
				},	
			},	
		},
		["2nd ArmorBrigade TurkishExpeditionaryForces"] = {
			task = "Strike",
			priority = 7,
			picture = {},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 2,
			},
			class = "static",
			elements = {
				[1] = {
					name = "2nd AB - TEF Div - 1-1",
				},
				[2] = {
					name = "2nd AB - TEF Div - 1-2",
				},
				[3] = {
					name = "2nd AB - TEF Div - 1-3",
				},
				[4] = {
					name = "2nd AB - TEF Div - 1-4",
				},
				[5] = {
					name = "2nd AB - TEF Div - 1-5",
				},
				[6] = {
					name = "2nd AB - TEF Div - 1-6",
				},
				[7] = {
					name = "2nd AB - TEF Div - 1-7",
				},
				[8] = {
					name = "2nd AB - TEF Div - 1-8",
				},
				[9] = {
					name = "2nd AB - TEF Div - 1-9",
				},
				[10] = {
					name = "2nd AB - TEF Div - 1-10",
				},	
				[11] = {
					name = "2nd AB - TEF Div - 1-11",
				},	
			},	
		},
		["3rd ArmorBrigade TurkishExpeditionaryForces"] = {
			task = "Strike",
			priority = 7,
			picture = {},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 2,
			},
			class = "static",
			elements = {
				[1] = {
					name = "3rd AB - TEF Div - 1-1",
				},
				[2] = {
					name = "3rd AB - TEF Div - 1-2",
				},
				[3] = {
					name = "3rd AB - TEF Div - 1-3",
				},
				[4] = {
					name = "3rd AB - TEF Div - 1-4",
				},
				[5] = {
					name = "3rd AB - TEF Div - 1-5",
				},
				[6] = {
					name = "3rd AB - TEF Div - 1-6",
				},
				[7] = {
					name = "3rd AB - TEF Div - 1-7",
				},
				[8] = {
					name = "3rd AB - TEF Div - 1-8",
				},
				[9] = {
					name = "3rd AB - TEF Div - 1-9",
				},
				[10] = {
					name = "3rd AB - TEF Div - 1-10",
				},	
				[11] = {
					name = "3rd AB - TEF Div - 1-11",
				},	
			},	
		},
		["4th ArmorBrigade TurkishExpeditionaryForces"] = {
			task = "Strike",
			priority = 7,
			picture = {},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 2,
			},
			class = "static",
			elements = {
				[1] = {
					name = "4th AB - TEF Div - 1-1",
				},
				[2] = {
					name = "4th AB - TEF Div - 1-2",
				},
				[3] = {
					name = "4th AB - TEF Div - 1-3",
				},
				[4] = {
					name = "4th AB - TEF Div - 1-4",
				},
				[5] = {
					name = "4th AB - TEF Div - 1-5",
				},
				[6] = {
					name = "4th AB - TEF Div - 1-6",
				},
				[7] = {
					name = "4th AB - TEF Div - 1-7",
				},
				[8] = {
					name = "4th AB - TEF Div - 1-8",
				},
				[9] = {
					name = "4th AB - TEF Div - 1-9",
				},
				[10] = {
					name = "4th AB - TEF Div - 1-10",
				},	
				[11] = {
					name = "4th AB - TEF Div - 1-11",
				},
			},	
		},
		["1st MechanizedBrigade TurkishExpeditionaryForces"] = {
			task = "Strike",
			priority = 7,
			picture = {},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 2,
			},
			class = "static",
			elements = {
				[1] = {
					name = "1st MB - TEF Div - 1-1",
				},
				[2] = {
					name = "1st MB - TEF Div - 1-2",
				},
				[3] = {
					name = "1st MB - TEF Div - 1-3",
				},
				[4] = {
					name = "1st MB - TEF Div - 1-4",
				},
				[5] = {
					name = "1st MB - TEF Div - 1-5",
				},
				[6] = {
					name = "1st MB - TEF Div - 1-6",
				},
				[7] = {
					name = "1st MB - TEF Div - 1-7",
				},
				[8] = {
					name = "1st MB - TEF Div - 1-8",
				},
				[9] = {
					name = "1st MB - TEF Div - 1-9",
				},
				[10] = {
					name = "1st MB - TEF Div - 1-10",
				},	
				[11] = {
					name = "1st MB - TEF Div - 1-11",
				},	
			},	
		},
		["2nd MechanizedBrigade TurkishExpeditionaryForces"] = {
			task = "Strike",
			priority = 7,
			picture = {},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 2,
			},
			class = "static",
			elements = {
				[1] = {
					name = "2nd MB - TEF Div - 1-1",
				},
				[2] = {
					name = "2nd MB - TEF Div - 1-2",
				},
				[3] = {
					name = "2nd MB - TEF Div - 1-3",
				},
				[4] = {
					name = "2nd MB - TEF Div - 1-4",
				},
				[5] = {
					name = "2nd MB - TEF Div - 1-5",
				},
				[6] = {
					name = "2nd MB - TEF Div - 1-6",
				},
				[7] = {
					name = "2nd MB - TEF Div - 1-7",
				},
				[8] = {
					name = "2nd MB - TEF Div - 1-8",
				},
				[9] = {
					name = "2nd MB - TEF Div - 1-9",
				},
				[10] = {
					name = "2nd MB - TEF Div - 1-10",
				},	
				[11] = {
					name = "2nd MB - TEF Div - 1-11",
				},	
			},	
		},
		["3rd MechanizedBrigade TurkishExpeditionaryForces"] = {
			task = "Strike",
			priority = 7,
			picture = {},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 2,
			},
			class = "static",
			elements = {
				[1] = {
					name = "3rd MB - TEF Div - 1-1",
				},
				[2] = {
					name = "3rd MB - TEF Div - 1-2",
				},
				[3] = {
					name = "3rd MB - TEF Div - 1-3",
				},
				[4] = {
					name = "3rd MB - TEF Div - 1-4",
				},
				[5] = {
					name = "3rd MB - TEF Div - 1-5",
				},
				[6] = {
					name = "3rd MB - TEF Div - 1-6",
				},
				[7] = {
					name = "3rd MB - TEF Div - 1-7",
				},
				[8] = {
					name = "3rd MB - TEF Div - 1-8",
				},
				[9] = {
					name = "3rd MB - TEF Div - 1-9",
				},
				[10] = {
					name = "3rd MB - TEF Div - 1-10",
				},	
				[11] = {
					name = "3rd MB - TEF Div - 1-11",
				},	
			},	
		},
		["1st ArtySupportDivision TurkishExpeditionaryForces"] = {
			task = "Strike",
			priority = 7,
			picture = {},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 2,
			},
			class = "static",
			elements = {
				[1] = {
					name = "1st ASD - TEF Div - 1-1",
				},
				[2] = {
					name = "1st ASD - TEF Div - 1-2",
				},
				[3] = {
					name = "1st ASD - TEF Div - 1-3",
				},
				[4] = {
					name = "1st ASD - TEF Div - 1-4",
				},
				[5] = {
					name = "1st ASD - TEF Div - 1-5",
				},
				[6] = {
					name = "1st ASD - TEF Div - 1-6",
				},
				[7] = {
					name = "1st ASD - TEF Div - 1-7",
				},
				[8] = {
					name = "1st ASD - TEF Div - 1-8",
				},
				[9] = {
					name = "1st ASD - TEF Div - 1-9",
				},
				[10] = {
					name = "1st ASD - TEF Div - 1-10",
				},	
			},	
		},
		["2nd ArtySupportDivision TurkishExpeditionaryForces"] = {
			task = "Strike",
			priority = 7,
			picture = {},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 2,
			},
			class = "static",
			elements = {
				[1] = {
					name = "2nd ASD - TEF Div - 1-1",
				},
				[2] = {
					name = "2nd ASD - TEF Div - 1-2",
				},
				[3] = {
					name = "2nd ASD - TEF Div - 1-3",
				},
				[4] = {
					name = "2nd ASD - TEF Div - 1-4",
				},
				[5] = {
					name = "2nd ASD - TEF Div - 1-5",
				},
				[6] = {
					name = "2nd ASD - TEF Div - 1-6",
				},
				[7] = {
					name = "2nd ASD - TEF Div - 1-7",
				},
				[8] = {
					name = "2nd ASD - TEF Div - 1-8",
				},
				[9] = {
					name = "2nd ASD - TEF Div - 1-9",
				},
				[10] = {
					name = "2nd ASD - TEF Div - 1-10",
				},	
			},	
		},
		["Turkish Army Supply Convoys 1"] = {
			task = "Strike",
			priority = 6,
			picture = {},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 2,
			},
			class = "vehicle",
			name = "1st SC - TEF",
		},
		["Turkish Army Supply Convoys 2"] = {
			task = "Strike",
			priority = 6,
			picture = {},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 2,
			},
			class = "vehicle",
			name = "2nd SC - TEF",
		},
		["Turkish Army Supply Convoys 3"] = {
			task = "Strike",
			priority = 6,
			picture = {},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 2,
			},
			class = "vehicle",
			name = "3rd SC - TEF",
		},
		["Turkish Army Supply Convoys 4"] = {
			task = "Strike",
			priority = 6,
			picture = {},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 2,
			},
			class = "vehicle",
			name = "4th SC - TEF",
		},
		["1st Guerilla Convoy of Azerbaïdjian Militia"] = {
			task = "Strike",
			priority = 4,
			picture = {},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 2,
			},
			class = "vehicle",
			name = "1st GC AZBJ militia",
		},
		["2nd Guerilla Convoy of Azerbaïdjian Militia"] = {
			task = "Strike",
			priority = 4,
			picture = {},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 2,
			},
			class = "vehicle",
			name = "2nd GC AZBJ militia",
		},
		["3rd Guerilla Convoy of Azerbaïdjian Militia"] = {
			task = "Strike",
			priority = 4,
			picture = {},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 2,
			},
			class = "vehicle",
			name = "3rd GC AZBJ militia",
		},
		["4th Guerilla Convoy of Azerbaïdjian Militia"] = {
			task = "Strike",
			priority = 4,
			picture = {},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 2,
			},
			class = "vehicle",
			name = "4th GC AZBJ militia",
		},
		["Airlift Maykop-Khanskaya"] = {
			task = "Transport",
			priority = 1,
			attributes = {},
			firepower = {
				min = 1,
				max = 1,
			},
			base = "Tbilissi-Lochini",
			destination = "Maykop-Khanskaya",
		},
		["Airlift Tbilissi-Lochini"] = {
			task = "Transport",
			priority = 1,
			attributes = {},
			firepower = {
				min = 1,
				max = 1,
			},
			base = "Maykop-Khanskaya",
			destination = "Tbilissi-Lochini",
		},
		["Airlift Nalchik"] = {
			task = "Transport",
			priority = 1,
			attributes = {},
			firepower = {
				min = 1,
				max = 1,
			},
			base = "Kutaisi",
			destination = "Nalchik",
		},
		["Airlift Kutaisi"] = {
			task = "Transport",
			priority = 1,
			attributes = {},
			firepower = {
				min = 1,
				max = 1,
			},
			base = "Nalchik",
			destination = "Kutaisi",
		},
		["Airlift Senaki-Kolkhi"] = {
			task = "Transport",
			priority = 1,
			attributes = {},
			firepower = {
				min = 1,
				max = 1,
			},
			base = "Sochi-Adler",
			destination = "Senaki-Kolkhi",
		},
		["Airlift Sochi-Adler"] = {
			task = "Transport",
			priority = 1,
			attributes = {},
			firepower = {
				min = 1,
				max = 1,
			},
			base = "Senaki-Kolkhi",
			destination = "Sochi-Adler",
		},
		["Airlift Mi-8 Kobuleti"] = {
			task = "Transport",
			priority = 1,
			attributes = {},
			firepower = {
				min = 1,
				max = 1,
			},
			base = "FARP-1st GHR",
			destination = "Kobuleti",
		},
		["Airlift Mi-8 Senaki-Kolkhi"] = {
			task = "Transport",
			priority = 1,
			attributes = {},
			firepower = {
				min = 1,
				max = 1,
			},
			base = "FARP-1st GHR",
			destination = "Senaki-Kolkhi",
		},
			
		-- ["Turkish Air Defense Hawk batterie Batumi"] = {
			-- task = "Strike",
			-- priority = 10,
			-- attributes = {"SAM"},
			-- firepower = {
				-- min = 2,
				-- max = 4,
			-- },
			-- class = "vehicle",
			-- name = "Batumi Air Defence Hawk",
		-- },
	},
}